<?php



include 'conn.php';
include 'ida.php';

//obtenemos datos de la tabla de servicios extras si se solicita un id en especifico y si no se requiere actualizar la tabla

if (isset($_POST['id']) && !isset($_POST['update'])) {

  $id = $_POST['id'];

  $stmt = $conn->prepare("SELECT * FROM servicios_extras WHERE id = ?");

  $stmt->bind_param("i", $id);

  $stmt->execute();



  // Vincular los resultados a variables

  $resultado = $stmt->get_result();



  // Obtener los datos en un array asociativo

  while ($fila = $resultado->fetch_assoc()) {

    // Procesar el estado

    if ($fila['status'] == 1) {

        $fila['status'] = 'Activo';

    } else {

        $fila['status'] = 'Inactivo';

    }



    // Crear un array asociativo para cada fila

    $datos[] = array(

        'id' => $fila['id'],

        'servicio' => $fila['servicio'],

        'costo' => $fila['costo'],

        'status' => $fila['status'],

        'empresa' => $fila['empresa']

    );

  }



  echo json_encode(array("data" => $datos));



} elseif (isset($_POST['update'])) {

  $id = $_POST['id'];

  $servicio = $_POST['servicio'];

  $costo = $_POST['costo'];

  $empresa = $_POST['empresa'];

  //actualizamos la tabla

  $stmt = $conn->prepare("UPDATE servicios_extras SET servicio = ?, costo = ?, empresa = ? WHERE id = ?");

  $stmt->bind_param("sssi", $servicio, $costo, $empresa, $id);

  $stmt->execute();



  if ($stmt->affected_rows > 0) {

    echo json_encode(array('status' => 'success', 'message' => 'Actualización realizada con éxito.'));

  } else {

    echo json_encode(array('status' => 'error', 'message' => 'La actualización falló: ' . $stmt->error));

  }



} else {

// Preparar la consulta
$stmt = $conn->prepare("SELECT id, servicio, costo, status, empresa FROM servicios_extras WHERE ida = ?");
if (!$stmt) {
        echo "Error preparando la consulta: " . $conn->error;
        exit;
}

// Vincular parámetros y ejecutar
$stmt->bind_param('s', $ida);
$stmt->execute();

// Vincular variables a las columnas del resultado

$stmt->bind_result($id, $servicio, $costo, $status, $empresa);
$datos = [];

// Obtener los datos en un array asociativo
while ($stmt->fetch()) {

    // Crear un array asociativo para cada fila

    $datos[] = array(

            'id' => $id,

            'servicio' => $servicio,

            'costo' => $costo,

            'status' => $status,

            'empresa' => $empresa

    );

}
echo json_encode(array("data" => $datos));

}

// Cerrar la declaración

$stmt->close();

// Cerrar la conexión

$conn->close();

?>

