<?php

// Mostramos errores
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Conexión a la base de datos
include 'conn.php';



// Mostrar los nombres de los hoteles
include 'ida.php';
$stmt = $conn->prepare("SELECT hotel FROM hoteles WHERE status = 1 AND ida = ? ORDER BY zona ASC");

if ($stmt === false) {
    send_response('error', 'Error en la consulta SQL: ' . $conn->error);
}

$stmt->bind_param('s', $ida);
$stmt->execute();
$stmt->bind_result($hotel);

$hoteles = array();
while ($stmt->fetch()) {
    $hoteles[] = $hotel; // Solo guardamos el nombre del hotel
}

// creamos una respuesta json tipo string
$response = json_encode($hoteles);

// Enviamos la respuesta al cliente
echo $response;


// Cerrar la declaración y conexión
$stmt->close();
$conn->close();

?>



