
$(document).ready(function() {

  var ida = $('#ida').val();

  var idr = $('#idrAsingado').val();

  var fecha = $('#flatpickr-date').val();

 console.log(fecha);

  $('#reservas_table').DataTable({
    ajax: {
      url: 'func/get-reservas.php',
      type: 'POST',
      data: {ida: ida}
      //escondemos o mostramos el id llegadas o salidas dependiendo del tipo de servicio

    },
      columns: [
          { data: '' },
          { data: 'id' },
          { data: 'idr' },
          { data: 'name' },
          { data: 'agencia' },
          { data: 'empresa' },
          { data: 'chofer' },
          { data: 'hotel' },
          { data: 'serviceText'},
          { data: 'car'},
          { data: 'serviceDate' },
          { data: 'idr' },
      ],
      columnDefs: [
          {
            // For Responsive
            className: 'control',
            orderable: false,
            responsivePriority: 2,
            searchable: false,
            targets: 0,
            render: function(data, type, full, meta) {
              return '';
            }
          },
          {
              targets: 1,
              searchable: false,
              visible: false,
          },

            {
              targets: 2,
              searchable: true,
            },
            {
              targets: 3,
              searchable: true,
            },
            {
                  targets: 4,
                  searchable: true,
            },
            {
                targets: 5,
                searchable: true,
            },
            {
                targets: 6,
                searchable: true,
            },
            {
                targets: 7,
                searchable: true,
            },
            {
                targets: 8,
                searchable: true,
            },
            {
                targets: 9,
                searchable: true,
            },
            {
              targets: 10,
              searchable: true,
          },
            {
                  targets: -1,
                  searchable: false,
                  render: function(data, type, full, meta) {
                    // boton eliminar
                    return '<div style="display: flex;"><i class="fa-solid fa-eye text-primary editar-reserva ms-3"  data-bs-toggle="modal" data-bs-target="#editar_reserva" data-datos="'+data+'"></i><i class="fa-solid fa-trash text-danger eliminar-reserva ms-3" data-datos="'+data+'"></i></div>';
                  }
            }
            

      ],
    
  });

  var fecha = new Date();
  var dia = String(fecha.getDate()).padStart(2, '0');
  var mes = String(fecha.getMonth() + 1).padStart(2, '0'); // Los meses en JavaScript comienzan desde 0
  var ano = fecha.getFullYear();

  var fechaActual = ano + '-' + mes + '-' + dia;


  // Inicializa el DataTable
  var table = $('#reservas_table_diarios').DataTable({
    ajax: {
      url: 'func/get_reservas.php',
      type: 'POST',
      data: {
          ida: ida, // `ida` debe ser definido en tu script o en el entorno
          fecha: fechaActual // `fechaActual` debe ser definido en tu script o en el entorno
      },
      dataSrc: 'data' // DataTables procesará la propiedad `data` del objeto JSON
    },
    columns: [
      { data: null, defaultContent: '' }, // Columna de control
      
      { data: 'name' },
      { data: 'hotel' },
      { data: 'airline' },
      { data: 'time'},
      { 
          data: 'status',
          render: function(data, type, row) {
              if (data === 'completed') {
                  return '<span class="text-success">' + data + '</span>';
              } else {
                  return data;
              }
          }
      },
      { data: 'empresa' },
      { data: 'chofer' },
      { data: 'idr' }
    ],
    columnDefs: [
      {
          className: 'control',
          orderable: false,
          responsivePriority: 2,
          searchable: false,
          targets: 0,
          visible: false,
          render: function(data, type, full, meta) {
              return '';
          }
      },
      {
          targets: 1,
          searchable: false,
          
      },
      {
          targets: 2,
          searchable: true,
      },
      {
          targets: 3,
          searchable: true,
      },
      {
          targets: 4,
          searchable: true,
      },
      {
        targets: 5,
        searchable: true,
      },
      {
      targets: 6, // Ajusta el índice al que corresponda `empresa`
      searchable: true,
     },
     {
      targets: 7, // Ajusta el índice al que corresponda `chofer`
      searchable: true,
     },
  
      {
          targets: -1,
          searchable: false,
          render: function(data, type, full, meta) {
              return '<div style="display: flex;"><i class="fa-solid fa-eye text-primary editar-reserva ms-3" data-bs-toggle="modal" data-bs-target="#editar_reserva" data-datos="'+data+'"></i><i class="fa-solid fa-trash text-danger eliminar-reserva ms-3" data-datos="'+data+'"></i></div>';
          }
      }
    ],
  });
  $('#reservas_table_diarios tbody').on('click', 'tr', function() {

  document.getElementById('serviceStatus').textContent = '';
  // Asegúrate de que `table` está definido
  if (table) {
    var data = table.row(this).data(); // Obtén los datos de la fila clicada
    if (data) {
      $('#verDetallesBtn').attr('data-datos', data.idr);
      $('#nameSing').val(data.name);
      $('#idr').val(data.idr);
      $('#generar_pdf_actual').attr('href', 'my-reservation.php?idr='+ data.idr + '&ida=DESER&back=0&url=servicios&admin=1&action=pdf');
      $('#verDetallesBtn').attr('data-datos', data.idr);

      if (data.shopping == 1) {
        $('#shoppingIcon').show();
        //le añadimos un tooltip al icono de carrito de compras de esta manera data-bs-toggle="tooltip" data-bs-offset="0,4" data-bs-placement="top" data-bs-custom-class="tooltip-primary" title="Primary tooltip"
      } else {
        $('#shoppingIcon').hide();
      }

       //verificamos si el servicio requiere babyseat, carseat o boosterseat
       if (data.babyseat >= 1) {
        $('#babyseatIcon').show();
        //añadiños title="Requiere + data.babyseat+ " asiento(s) para bebé" al icono de babyseat
        document.getElementById('babyseatIcon').setAttribute('title', 'Requiere '+ data.babyseat+ ' asiento(s) (Baby seat)');
          // Inicializa el tooltip
          var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
          var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl)
          })
      } else {
        $('#babyseatIcon').hide();
      }
      if (data.carseat >= 1) {
        $('#carseatIcon').show();
        //añadimos title="Requiere + data.carseat+ " asiento(s) para niño" al icono de carseat
        document.getElementById('carseatIcon').setAttribute('title', 'Requiere '+ data.carseat+ ' asiento(s) (Car seat)');
          // Inicializa el tooltip
          var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
          var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl)
          })
      } else {
        $('#carseatIcon').hide();
      }
      if (data.boosterseat >= 1) {
        $('#boosterseatIcon').show();
        //añadimos title="Requiere + data.boosterseat+ " asiento(s) para niño" al icono de boosterseat
        document.getElementById('boosterseatIcon').setAttribute('title', 'Requiere '+ data.boosterseat+ ' asiento(s) (Booster seat)');
          // Inicializa el tooltip
          var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
          var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl)
          })
      } else {
        $('#boosterseatIcon').hide();
      }

        //si status es igual a "Confirmed" se cambia el color del texto a verde
        if (data.status == "Confirmed") {
          document.getElementById('serviceStatus').style.color = 'green';
          document.getElementById('serviceStatus').innerHTML = data.status + ' <i class="fa-regular fa-pen-to-square" id="edit_status" data-idr="'+ data.idr + '"></i>';
          $('#pagado').show();
        }
        if (data.status == "Completed") {
          document.getElementById('serviceStatus').style.color = 'blue';
          document.getElementById('serviceStatus').innerHTML = data.status;
          $('#pagado').hide();
        } else if (data.status == "Cancelled"){
          document.getElementById('serviceStatus').style.color = 'red';
          document.getElementById('serviceStatus').innerHTML = data.status + ' <i class="fa-regular fa-pen-to-square" id="edit_status" data-idr="'+ data.idr + '"></i>';
          $('#pagado').show();
        }

        if(data.status == "No Show"){
          document.getElementById('serviceStatus').style.color = 'orange';
          document.getElementById('serviceStatus').innerHTML = data.status + ' <i class="fa-regular fa-pen-to-square" id="edit_status" data-idr="'+ data.idr + '"></i>';
          $('#pagado').show();
        }
        if(data.status == "Pending"){
          document.getElementById('serviceStatus').style.color = 'gray';
          document.getElementById('serviceStatus').innerHTML = data.status + ' <i class="fa-regular fa-pen-to-square" id="edit_status" data-idr="'+ data.idr + '"></i>';
          $('#pagado').show();
        }
      //cargamos la imagen del vehiculo dependiendo data.car
      if (data.img) {
        document.getElementById('carImg').src = data.img; // Asignar la ruta de la imagen
      } else {
        document.getElementById('carImg').src = 'https://deserttravelplus.com/btec_v1/assets/img/cars/anyCar.jpg'; // Ruta de la imagen predeterminada si no se encuentra una imagen específica
      }
      
      document.getElementById('car').textContent = data.car;

      if (data.pay_method == 'Paid') {
        $('#servicePay').html('<i class="fas fa-money-check-alt"></i> ' +data.pay_method+ ' $' + data.total);
        //pone,os la clase success al elemento con id servicePay
        document.getElementById('servicePay').classList.add('text-success');
                  //agegamo el texto marcar como pendiente al boton con el id pagado
                  $('#pagado').html('<i class="fa-solid fa-xmark me-2"></i> Marcar como pago pendiente');
                  //cambiemos el valor del boton con el id pagado a Pending
                  $('#pagado').val('Pending');
                  //cambiamos la clase del boton con el id pagado a btn-warning
                  document.getElementById('pagado').classList.remove('btn-success');
                  document.getElementById('pagado').classList.add('btn-warning');
      }else{
        $('#pagado').html('<i class="fa-solid fa-check me-2"></i> Marcar como pagado');
        $('#pagado').val('Paid');
        $('#servicePay').html('<i class="fas fa-money-check-alt"></i> ' +data.pay_method+ ' $' + data.total);
        document.getElementById('pagado').classList.remove('btn-warning');
        document.getElementById('pagado').classList.add('btn-success');
        //pone,os la clase danger al elemento con id servicePay
        document.getElementById('servicePay').classList.add('text-danger');
        //buscamos si el servicio tiene observaciones con data.obs_int
        if (data.cobro == 1) {
          $('#serviceObsInt').html('<p><b>Instrucción de cobro:</b> '+ data.obs_int +'</p><button type="button" class="btn btn-label-secondary btn-sm" data-toggle="modal" data-target="#modalObservaciones" id="modalObs" data-idr="'+ data.idr + '"><i class="fa-regular fa-pen-to-square"></i> Editar instrucciónes</button>');
        } else {
          document.getElementById('serviceObsInt').classList.remove('alert');
          document.getElementById('serviceObsInt').classList.remove('alert-warning');
          //si no trae intruccion agregamos un boton pequeño con la clase btn-warning para agregar intruccion de pago
          $('#serviceObsInt').html('<p>Sin intrucción de pago.</p><button type="button" class="btn btn-warning btn-sm" data-toggle="modal" data-target="#modalObservaciones" id="modalObs" data-idr="'+ data.idr + '"><i class="fas fa-exclamation-triangle"></i> Agregar instrucción de cobro</button>');
          //quitamos clase class="alert alert-warning" role="alert" al elemento con id serviceObsInt
        }
      }     

      let details = `Detalle del servicio: Pasajero ${data.name}, `;
      var airline =  '';
      details += `Pax: ${data.pax}, `;
      details += `Tel: ${data.phone}, `;
      switch (data.service) {
        case 'ona':
        case 'tra':
        case 'ope':
          details += `Destino: ${data.arrival_hotel}`;
          airline =  data.arrival_airline;
          flight = data.arrival_flight;
          
          var dateTimeString = data.arrival_date + ' ' + data.time+ ':00';
          //aplicamos la clase text-primary al elemento con id serviceText
          document.getElementById('serviceText').classList.add('text-primary');
          document.getElementById('serviceText').textContent =  data.serviceText;
          document.getElementById('serviceTime').textContent = formatDate(dateTimeString);
          
          document.getElementById('aerolinea').textContent =  data.arrival_airline + ' ' + data.arrival_flight;
          break;
        case 'ond':
          details += `Origen ${data.departure_hotel}`;
          airline =  data.departure_airline;
          flight = data.departure_flight;
          var dateTimeString = data.departure_date + ' ' + data.time+ ':00';
          //aplicamos la clase text-warning al elemento con id serviceText
          document.getElementById('serviceText').classList.add('text-warning');
          document.getElementById('serviceText').textContent =  data.serviceText;
          document.getElementById('serviceTime').textContent = formatDate(dateTimeString);
          document.getElementById('aerolinea').textContent =  data.departure_airline + ' ' + data.departure_flight;
          break;
        case 'roa':
          var isAfterArrival = new Date() > new Date(data.time);
          if (isAfterArrival) {
            airline =  data.departure_airline;
            flight = data.departure_flight;
            details += `Origen ${data.departure_hotel}`;
            const dateTimeString = data.departure_date + ' ' + data.time+ ':00';
            //aplicamos la clase text-warning al elemento con id serviceText
            document.getElementById('serviceText').classList.add('text-warning');
            document.getElementById('serviceText').textContent =  data.serviceText;
            document.getElementById('aerolinea').textContent =  data.departure_airline + ' ' + data.departure_flight;
            document.getElementById('serviceTime').textContent = formatDate(dateTimeString);
          } else {
            airline =  data.arrival_airline;
            flight = data.arrival_flight;
            details += `Destino ${data.arrival_hotel}`;
            const dateTimeString = data.arrival_date + ' ' + data.time+ ':00';
            //aplicamos la clase text-primary al elemento con id serviceText
            document.getElementById('serviceText').classList.add('text-primary');
            document.getElementById('serviceText').textContent =  data.serviceText;
            document.getElementById('serviceTime').textContent = formatDate(dateTimeString);
            document.getElementById('aerolinea').textContent =  data.arrival_airline + ' ' + data.arrival_flight;
            document.getElementById('serviceDetails').textContent = details;
          }
          break;
          default:
            // Manejar cualquier otro valor que no esté especificado
            console.log('Valor de data.service no reconocido');

      }
      //si chofer no es null o viene vacio agregamos el chofer asignado a details si noi agregamos un boton para asignar chofer
      if (data.chofer != null && data.chofer != '') {
                details += `, Chofer: ${data.chofer}`;
                details += `<br /><button type="button" class="btn btn-secondary btn-sm mt-3 add-choferes" data-bs-toggle="modal" data-bs-target="#add_chofer" data-idr="${data.idr}"><i class="fas fa-user-tie"></i> Editar chofer</button>`;
      } else {
                details += `<button type="button" class="btn btn-warning btn-sm mt-3 add-choferes" data-bs-toggle="modal" data-bs-target="#add_chofer" data-idr="${data.idr}"><i class="fas fa-user-tie"></i> Asignar chofer</button>`;
      }

      document.getElementById('serviceDetails').innerHTML = details;
      //si el servicio tieneasignada una agencia la agregamos a el elemento con id agency
      if (data.agencia != null && data.agencia != '') {
        $('#agency').html('<p>Agencia: <br><span class="text-primary"><i class="fas fa-building"></i> <b>' + data.agencia + '</b></span></p>');
        
        //creamos un boton para que el usiario pueda editar la agencia asignada
        $('#agency').append('<button type="button" class="btn btn-secondary btn-sm mt-0 add-proveedor" data-bs-toggle="modal" data-bs-target="#add_proveedor" id="edit_agency" data-idr="'+ data.idr + '"><i class="fa-regular fa-pen-to-square"></i> Editar Agencia</button>');
      }else{
        $('#agency').html('<p>Agencia: <br><i class="fas fa-building"></i> Sin agencia asignada</p>');
        //creamos un boton para que el usiario pueda agregar la agencia asignada
        $('#agency').append('<button type="button" class="btn btn-warning btn-sm add-proveedor" data-bs-toggle="modal" data-bs-target="#add_proveedor" id="edit_agency" data-idr="'+ data.idr + '"><i class="fas fa-building"></i> Asignar Agencia</button>');
      }

      if (data.agencia != null && data.agencia != '') {
        $('#agency').html('<p>Agencia: <br><span class="text-primary"><i class="fas fa-building"></i> <b>' + data.agencia + '</b></span></p>');
        
        //creamos un boton para que el usiario pueda editar la agencia asignada
        $('#agency').append('<button type="button" class="btn btn-secondary btn-sm mt-0 add-proveedor" data-bs-toggle="modal" data-bs-target="#add_proveedor" id="edit_agency" data-idr="'+ data.idr + '"><i class="fa-regular fa-pen-to-square"></i> Editar Agencia</button>');
      }else{
        $('#agency').html('<p>Agencia: <br><i class="fas fa-building"></i> Sin agencia asignada</p>');
        //creamos un boton para que el usiario pueda agregar la agencia asignada
        $('#agency').append('<button type="button" class="btn btn-warning btn-sm add-proveedor" data-bs-toggle="modal" data-bs-target="#add_proveedor" id="edit_agency" data-idr="'+ data.idr + '"><i class="fas fa-building"></i> Asignar Agencia</button>');
      }
      
      if (data.empresa != null && data.empresa != '' && data.empresa != 'undefined') {
        $('#proveedorText').html('<p>Proveedor: <br><span class="text-primary"><i class="fas fa-building"></i> <b>' + data.empresa + '</b></span></p>');
        $('#proveedorText').append('<button type="button" class="btn btn-secondary btn-sm mt-0 actualizar-proveedor" data-bs-toggle="modal" data-bs-target="#actualizar_proveedor" id="edit_empresa" data-idr="'+ data.idr + '"><i class="fa-regular fa-pen-to-square"></i> Editar Proveedor</button>');
      }else{
        $('#proveedorText').html('<p>Proveedor: <br><i class="fas fa-building"></i> Sin proveedor asignado</p>');
        $('#proveedorText').append('<button type="button" class="btn btn-warning btn-sm actualizar-proveedor" data-bs-toggle="modal" data-bs-target="#actualizar_proveedor" id="edit_empresa" data-idr="'+ data.idr + '"><i class="fas fa-building"></i> Asignar Proveedor</button>');
       
      }

    } else {
      console.log('No se encontraron datos para la fila seleccionada');
    }
  } else {
    console.log('El DataTable no está inicializado correctamente');
  }
});



var salidas = $('#servicios_salidas').DataTable({

  

    ajax: {

      url: 'func/get-salidas.php',

      type: 'POST',

      data: function(d) {

        // Aquí, puedes añadir o modificar los datos que se enviarán con cada solicitud AJAX

        d.ida = $('#ida').val(); // Asume que tienes un elemento con id='ida' para el IDA 

        d.fecha = $('#flatpickr-date').val(); // Fecha seleccionada por el usuario

      }

    },

      columns: [

          { data: '' },

          { data: 'id' },

          { data: 'departure_hotel' },

          { data: 'departure_destino' },

          

          { data: 'departure_flight' },

          { data: 'departure_pickuptime' },

          { data: 'pax' },

          { data: 'name' },

          { data: 'phone'},

          { data: 'agencia'},

          { data: 'empresa' },

          { data: 'chofer' },

          { data: 'balance' },
           //observaciones y observaciones internas
          { data: 'obs' },

          { data: 'idr' },

          { data: 'idr' },

      ],

      columnDefs: [

          {

            // For Responsive

            className: 'control',

            orderable: false,

            responsivePriority: 2,

            searchable: false,

            targets: 0,

            render: function(data, type, full, meta) {

              return '';

            }

          },

          //

          {

            targets: 1,

            searchable: false,

            visible: false,

        },

          {

              targets: 2,

              searchable: false,

              visible: true,

          },

          //hotel

          {

              targets: 3,

              searchable: false,


            },

            //airline

            {

              targets: 4,

              searchable: true,
              render: function(data, type, row) {
                return data + '-' + row.departure_airline;
              }

            },

            //pax

            {

                  targets: 5,

                  searchable: true,

            },

            //name

            {

                targets: 6,

                searchable: true,

            },

            //phone

            {

                targets: 7,

                searchable: true,

            },

            //agencia

            {

                targets: 8,

                searchable: true,

            },

            //chofer

            {

                targets: 9,

                searchable: true,

                

            },

            //balance

            {

                targets: 10,

                searchable: true,

                render: function(data, type, row) {

                  // Comprueba si proveedor es igual a 'Sin Asignar' 
  
                  if (data == 'Sin Asignar') { // Si 'data' (el valor de 'proveedor') es igual a 'Sin Asignar'
  
                      // Devuelve un botón o ícono que abrirá el modal update_proveedor_modal
  
                      return '<button type="button" data-idr="' + row.idr + '" class="btn btn-primary btn-sm add-proveedor" data-bs-toggle="modal" data-bs-target="#update_proveedor_modal"><i class="fa-solid fa-plus"></i></button>';
  
                  } else {
  
                      // Si hay un proveedor, simplemente devuelve el nombre o dato del proveedor
  
                      return '<span data-idr="' + row.idr + '" class="text-primary add-proveedor" data-bs-toggle="modal" data-bs-target="#update_proveedor_modal">'+data+'</span>';
  
                  }
  
                }

            },
            {

                targets: 11,
                searchable: true,
                render: function(data, type, row) {
                  // Comprueba si chofer es null o cómo determinas que no hay chofer asignado
                  if (!data) { // Si 'data' (el valor de 'chofer') es null, undefined o una cadena vacía
                      // Devuelve un botón o ícono que abrirá el modal
                      return '<button type="button" data-idr="' + row.idr + '" class="btn btn-primary btn-sm add-choferes" data-bs-toggle="modal" data-bs-target="#add_chofer"><i class="fa-solid fa-plus"></i></button>';

                  } else {

                      // Si hay un chofer, simplemente devuelve el nombre o dato del chofer
                      return '<span data-idr="' + row.idr + '" class="text-success add-choferes" data-bs-toggle="modal" data-bs-target="#add_chofer">'+data+'</span>';

                  }

                }

            },

           

            {
//observaciones y observaciones internas
                targets: 12,
                searchable: true,
                

            },
             //idr
            {

              targets: 13,
              searchable: true,

          },

            

            {

                  targets: -1,

                  searchable: false,

                  render: function(data, type, full, meta) {

                    // boton eliminar

                      return '<i class="fa-solid fa-pencil text-primary editar-reserva ms-3"  data-bs-toggle="modal" data-bs-target="#editar_reserva" data-datos="'+data+'"></i><i class="fa-solid fa-trash text-danger eliminar-reserva ms-3" data-datos="'+data+'"></i>';

                  }

            }

      ],

      order: [[5, 'asc']]

});

var llegadas = $('#servicios_llegadas').DataTable({

  

  ajax: {

    url: 'func/get-llegadas.php',

    type: 'POST',

    data: function(d) {

      // Aquí, puedes añadir o modificar los datos que se enviarán con cada solicitud AJAX

      d.ida = $('#ida').val(); // Asume que tienes un elemento con id='ida' para el IDA 

      d.fecha = $('#flatpickr-date').val(); // Fecha seleccionada por el usuario

    }

  },

    columns: [

        { data: '' },

        { data: 'id' },

        { data: 'arrival_pickup' },

        { data: 'arrival_hotel' },

        { data: 'arrival_flight' },

        { data: 'arrival_time' },

        { data: 'pax' },

        { data: 'name' },

        { data: 'phone'},

        { data: 'agencia'},

        { data: 'empresa' },

        { data: 'chofer' },

        { data: 'balance' },

        { data: 'obs' },

        { data: 'idr' },

        { data: 'idr' },

    ],

    columnDefs: [

        {

          // For Responsive

          className: 'control',

          orderable: false,

          responsivePriority: 2,

          searchable: false,

          targets: 0,

          render: function(data, type, full, meta) {

            return '';

          }

        },
        
        //pickup 

        {

          targets: 1,

          searchable: false,

          visible: false,

      },

        //hotel

        {

            targets: 2,

            searchable: false,

            visible: true,

        },

        //airline

        {

            targets: 3,

            searchable: false,
            

          },

          //pickuptime

          {

            targets: 4,

            searchable: true,
            render: function(data, type, row) {
              return data + '-' + row.arrival_airline;
            }
          },

          //pax

          {

                targets: 5,

                searchable: true,

          },

          //name

          {

              targets: 6,

              searchable: true,

          },

          //phone

          {

              targets: 7,

              searchable: true,

          },

          //phone

          {

              targets: 8,

              searchable: true,

          },

          //agencia

          {

              targets: 9,

              searchable: true,

              

          },

          //proveedor

          {

              targets: 10,

              searchable: true,

              render: function(data, type, row) {

                // Comprueba si proveedor es igual a 'Sin Asignar' 

                if (data == 'Sin Asignar') { // Si 'data' (el valor de 'proveedor') es igual a 'Sin Asignar'

                    // Devuelve un botón o ícono que abrirá el modal update_proveedor_modal

                    return '<button type="button" data-idr="' + row.idr + '" class="btn btn-primary btn-sm add-proveedor" data-bs-toggle="modal" data-bs-target="#update_proveedor_modal"><i class="fa-solid fa-plus"></i></button>';

                } else {

                    // Si hay un proveedor, simplemente devuelve el nombre o dato del proveedor

                    return '<span data-idr="' + row.idr + '" class="text-primary add-proveedor" data-bs-toggle="modal" data-bs-target="#update_proveedor_modal">'+data+'</span>';

                }

              }
              

          },

          //chofer
          {

              targets: 11,

              searchable: true,

              render: function(data, type, row) {

                // Comprueba si chofer es null o cómo determinas que no hay chofer asignado

                if (!data) { // Si 'data' (el valor de 'chofer') es null, undefined o una cadena vacía

                  // Devuelve un botón o ícono que abrirá el modal

                  return '<button type="button" data-idr="' + row.idr + '" class="btn btn-primary btn-sm add-choferes" data-bs-toggle="modal" data-bs-target="#add_chofer"><i class="fa-solid fa-plus"></i></button>';

              } else {

                  // Si hay un chofer, simplemente devuelve el nombre o dato del chofer

                  return '<span data-idr="' + row.idr + '" class="text-success add-choferes" data-bs-toggle="modal" data-bs-target="#add_chofer">'+data+'</span>';

              }

              }

          },

          //idr

          {

              targets: 12,

              searchable: true,

          },

          {
            targets: 13,

            searchable: true,

          },

          

          {

                targets: -1,

                searchable: false,

                render: function(data, type, full, meta) {

                  // boton eliminar

                    return '<i class="fa-solid fa-pencil text-primary editar-reserva ms-3"  data-bs-toggle="modal" data-bs-target="#editar_reserva" data-datos="'+data+'"></i><i class="fa-solid fa-trash text-danger eliminar-reserva ms-3" data-datos="'+data+'"></i>';

                }

          }

    ],

    order: [[5, 'asc']]

});

var translados = $('#servicios_translados').DataTable({ 
  ajax: {
    url: 'func/get-translados.php',
    type: 'POST',
    data: function(d) {
      d.ida = $('#ida').val(); 
      d.fecha = $('#flatpickr-date').val();
    }
  },
  columns: [
      { data: '' },
      { data: 'id' },
      { data: 'arrival_pickup' },
      { data: 'arrival_hotel' },
      
      { data: 'arrival_time' }, // pickup_time parece que falta en tu PHP
      { data: 'pax' },
      { data: 'name' },
      { data: 'phone'},
      { data: 'agencia'},
      { data: 'empresa' }, // empresa está en tu JOIN con proveedores
      { data: 'chofer' },
      { data: 'balance' }, // balance parece que falta en tu PHP
      { data: 'obs' },
      { data: 'idr' },
      { data: 'idr' }
  ],
  columnDefs: [
      {
        className: 'control',
        orderable: false,
        responsivePriority: 2,
        searchable: false,
        targets: 0,
        render: function(data, type, full, meta) {
          return '';
        }
      },
      // Otras definiciones de columnas
      {
          targets: 1,
          searchable: false,
          visible: false,
      },
      {
          targets: 2,
          searchable: false,
      },
      {
          targets: 3,
          searchable: true,
      },
      {
          targets: 4,
          searchable: true,
      },
      {
          targets: 5,
          searchable: true,
      },
      {
          targets: 6,
          searchable: true,
      },
      {
          targets: 7,
          searchable: true,
      },
      {
          targets: 8,
          searchable: true,
      },
      {
          targets: 9,
          searchable: true,
          render: function(data, type, row) {

            // Comprueba si proveedor es igual a 'Sin Asignar' 

            if (data == 'Sin Asignar') { // Si 'data' (el valor de 'proveedor') es igual a 'Sin Asignar'

                // Devuelve un botón o ícono que abrirá el modal update_proveedor_modal

                return '<button type="button" data-idr="' + row.idr + '" class="btn btn-primary btn-sm add-proveedor" data-bs-toggle="modal" data-bs-target="#update_proveedor_modal"><i class="fa-solid fa-plus"></i></button>';

            } else {

                // Si hay un proveedor, simplemente devuelve el nombre o dato del proveedor

                return '<span data-idr="' + row.idr + '" class="text-primary add-proveedor" data-bs-toggle="modal" data-bs-target="#update_proveedor_modal">'+data+'</span>';

            }

          }
      },
      {
          targets: 10,
          searchable: true,
          render: function(data, type, row) {

            // Comprueba si chofer es null o cómo determinas que no hay chofer asignado

            if (!data) { // Si 'data' (el valor de 'chofer') es null, undefined o una cadena vacía

              // Devuelve un botón o ícono que abrirá el modal

              return '<button type="button" data-idr="' + row.idr + '" class="btn btn-primary btn-sm add-choferes" data-bs-toggle="modal" data-bs-target="#add_chofer"><i class="fa-solid fa-plus"></i></button>';

          } else {

              // Si hay un chofer, simplemente devuelve el nombre o dato del chofer

              return '<span data-idr="' + row.idr + '" class="text-success add-choferes" data-bs-toggle="modal" data-bs-target="#add_chofer">'+data+'</span>';

          }

          }
      },
      {
          targets: 11,
          searchable: true,
      },
      {
          targets: 12,
          searchable: true,
      },
      {
          targets: 13,
          searchable: true,
      },
      {
          targets: -1,
          searchable: false,
          render: function(data, type, full, meta) {
            return '<i class="fa-solid fa-eye text-primary editar-reserva ms-3"  data-bs-toggle="modal" data-bs-target="#editar_reserva" data-datos="'+data+'"></i><i class="fa-solid fa-trash text-danger eliminar-reserva ms-3" data-datos="'+data+'"></i>';
          }
      }
  ],
  order: [[4, 'asc']]
});


$('#submit_date').click(function(e) {
  console.log('click submit_date');
  e.preventDefault(); // Previene el comportamiento predeterminado del botón

  var fechaInput = $('#flatpickr-date').val();
  console.log(fechaInput); // Verificar el valor del input

  // Forzar la fecha a las 00:00:00 en UTC para evitar problemas de zona horaria
  var fecha2 = new Date(fechaInput + 'T00:00:00');
  console.log(fecha2.toString()); // Verificar el objeto Date

  var opciones = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
  var fechaFormateada = fecha2.toLocaleDateString('en-US', opciones);

  $('.dateVisual').text(fechaFormateada);

  salidas.ajax.reload();
  llegadas.ajax.reload();
  translados.ajax.reload();
});

$(document).on("click", ".editar-reserva", function() {
  var datos = $(this).data('datos');

  $.ajax({
      type: "POST",
      url: "func/get-data-reserva.php",
      data: { idr: datos },
      success: function(data) {
          var data = JSON.parse(data);

          $('#edit-idr').val(data.data[0].idr);
          $('#edit-name').val(data.data[0].name);
          $('#edit-email').val(data.data[0].email);
          $('#edit-phone').val(data.data[0].phone);
          $('#edit-car').val(data.data[0].car);
          $('#edit-pax').val(data.data[0].pax);
          $('#edit-pagado').val(data.data[0].pagado);
          $('#edit-total').val(data.data[0].total);
          $('#edit-service').val(data.data[0].service);
          $('#edit-hotel-llegada').val(data.data[0].arrival_hotel);
          $('#edit-fecha-llegada').val(data.data[0].arrival_date);
          $('#edit-hora-llegada').val(data.data[0].arrival_time);
          $('#edit-aerolinea-llegada').val(data.data[0].arrival_airline);
          $('#edit-vuelo-llegada').val(data.data[0].arrival_flight);
          $('#edit-hotel-salida').val(data.data[0].departure_hotel);
          $('#edit-departure-destino').val(data.data[0].departure_destino);
          $('#edit-fecha-salida').val(data.data[0].departure_date);
          $('#edit-pickup-time').val(data.data[0].departure_pickuptime);
          $('#edit-hora-salida').val(data.data[0].departure_time);
          $('#edit-aerolinea-salida').val(data.data[0].departure_airline);
          $('#edit-vuelo-salida').val(data.data[0].departure_flight);
          $('#edit-bbs').val(data.data[0].babyseat);
          $('#edit-bos').val(data.data[0].boosterseat);
          $('#edit-hotel-pickup').val(data.data[0].arrival_pickup);
          $('#edit-crs').val(data.data[0].carseat);
          $('#edit-shopping').val(data.data[0].shopping);
          $('#edit-agencia-proveedor').val(data.data[0].nombre_proveedor); // Ajustar según el nuevo nombre
          $('#edit-costo-proveedor').val(data.data[0].costo_proveedor);
          $('#generar_pdf').attr('href', 'my-reservation.php?idr='+ data.data[0].idr + '&ida=DESER&back=0&url=servicios&admin=1&action=pdf');
          $('#edit-folio').val(data.data[0].folio);

          $('#edit-agencia-proveedor option').filter(function() {
            return $(this).text() === data.data[0].nombre_proveedor;
        }).prop('selected', true);

          if (data.data[0].shopping == 1) {
              $('#edit-shopping').attr('checked', true);
          } else {
              $('#edit-shopping').attr('checked', false);
          }

          $('#edit-obs').val(data.data[0].obs);
          $('#edit-obs-int').val(data.data[0].obs_int);
          $('#edit-id').val(data.data[0].reserva_id); // Cambiar 'id' por 'reserva_id'
          $('#edit-estado-reserva').val(data.data[0].estado_reserva);
          $('#edit-agencia').val(data.data[0].agencia);
          $('#prov').text(data.data[0].agencia);

          // Ajustar visualmente según el tipo de servicio
          if (data.data[0].service == 'One Way Arrival') {
              $('#llegadas').show();
              $('#salidas').hide();
              $('#txt-servicio').text('Llegada');
              $('#txt-hotel1').text('hotel de llegada');
              $('#dropoff-tra').hide();
              $('#txtFecha1').text('Fecha de llegada');
              $('#txtSalida').text('Salida');
          }
          if (data.data[0].service == 'One Way Departure') {
              $('#llegadas').hide();
              $('#salidas').show();
              $('#dropoff-tra').hide();
              $('#txtSalida').text('Salida');

          }
          if (data.data[0].service == 'Roundtrip Airport') {
              $('#llegadas').show();
              $('#salidas').show();
              $('.hide-tra').show();
              $('#txt-servicio').text('Llegada');
              $('#txt-hotel1').text('hotel de llegada');
              $('#dropoff-tra').hide();
              $('#txtSalida').text('Salida');
          }
          if (data.data[0].service == 'Transfer') {
              $('#llegadas').show();
              $('#salidas').hide();
              $('#dropoff-tra').show();
              $('.hide-tra').hide();
              $('#txt-servicio').text('Transfers');
              $('#txt-hotel1').text('Destino');
              $('#txt-hotel2').text('Origen');
              $('txtFecha1').text('Fecha de servicio');
              $('#txtHora1').text('Hora de servicio');
              $('#txtSalida').text('Salida');
          }
          if (data.data[0].service == 'Transfer Roundtrip') {
            $('#llegadas').show();
            $('#salidas').show();
            $('#dropoff-tra').show();
            $('.hide-tra').hide();
            $('#txt-servicio').text('Transfers');
            $('#txt-hotel1').text('Destino');
            $('#txt-hotel2').text('Origen');
            $('#txtFecha1').text('Fecha de servicio');
            $('#txtHora1').text('Hora de pickup');
            $('.js-hide').hide();
            $('#txtSalida').text('Regreso');
        }
          if (data.data[0].service == 'Open Service') {
              $('#llegadas').show();
              $('#salidas').hide();
              $('#dropoff-tra').hide();
              $('.hide-tra').hide();
              $('#txt-servicio').text(data.data[0].service);
              $('#txt-hotel1').text('Destino');
          }

          
        
      }
  });
});




$(document).on("click", ".actualizar-reserva", function() {
  var idract = $('#edit-idr').val();
  var ida = $('#ida').val();

    //obtenemos todos los campos a actualizar

    var nombre = $('#edit-name').val();

    var email = $('#edit-email').val();

    var telefono = $('#edit-phone').val();

    var pax = $('#edit-pax').val();

    var car = $('#edit-car').val();

    var pagado = $('#edit-pagado').val();

    var total = $('#edit-total').val();

    var hotel_llegada = $('#edit-hotel-llegada').val();

    var hotel_pickup = $('#edit-hotel-pickup').val();

    var fecha_llegada = $('#edit-fecha-llegada').val();

    var hora_llegada = $('#edit-hora-llegada').val();

    var aerolinea_llegada = $('#edit-aerolinea-llegada').val();

    var vuelo_llegada = $('#edit-vuelo-llegada').val();

    var hotel_salida = $('#edit-hotel-salida').val();

    var fecha_salida = $('#edit-fecha-salida').val();

    var hora_salida = $('#edit-hora-salida').val();

    var pickup_time = $('#edit-pickup-time').val();

    var aerolinea_salida = $('#edit-aerolinea-salida').val();

    var vuelo_salida = $('#edit-vuelo-salida').val();

    var bbs = $('#edit-bbs').val();

    var crs = $('#edit-crs').val();

    var bos = $('#edit-bos').val();

    var shopping = $('#edit-shopping').val();

    var obs_internas = $('#edit-obs-int').val();

    var agencia = $('#edit-agencia').val();

    //calculamos el balance

    var balance = total - pagado;
    var agencia_proveedor = $('#edit-agencia-proveedor').val();
    var costo_proveedor = $('#edit-costo-proveedor').val();
    var folio = $('#edit-folio').val();
    var moneda = $('#moneda').val();

    //validaciones
    //validar arrival_date si service es ona o roa y departure_date si service es ond o roa
 

    $.ajax({

      type: "POST",

      url: "func/actualizar-reserva.php",

      data: {ida: ida, idr: idract, nombre: nombre, email: email, telefono: telefono, pax: pax, car: car, pagado: pagado, total: total, hotel_llegada: hotel_llegada, hotel_pickup: hotel_pickup, fecha_llegada: fecha_llegada, hora_llegada: hora_llegada, aerolinea_llegada: aerolinea_llegada, vuelo_llegada: vuelo_llegada, hotel_salida: hotel_salida, fecha_salida: fecha_salida, hora_salida: hora_salida, pickup_time: pickup_time, aerolinea_salida: aerolinea_salida, vuelo_salida: vuelo_salida, bbs: bbs, crs: crs, bos: bos, shopping: shopping, obs_internas: obs_internas, balance: balance, agencia: agencia, agencia_proveedor: agencia_proveedor, costo_proveedor: costo_proveedor, folio: folio, moneda: moneda},

      success: function(data) {

        try {

        var data = JSON.parse(data);

        console.log(data);

        if (data.status === 'ok') {
          //escondemos el modal con el id editar_reserva
          $('#editar_reserva').modal('hide');
          salidas.ajax.reload();
          llegadas.ajax.reload();
          translados.ajax.reload();

        } else if (data.status === 'error') {

          alert(data.message);

        } else {

          alert('Respuesta desconocida');

        }

      } catch (error) {

        console.error("Error parsing JSON: ", error);

        console.log("Raw data: ", data);

      }

    }

    }); 

});

  

$('#crear_reserva').on('click', function () {

  var ida = $('#ida').val();
  var idr = $('#idrAsingado').val();
  var agencia = $('#agencia').val();
  var name = $('#name').val();
  var email = $('#email').val();
  var phone = $('#phone').val();
  var pax = $('#pax').val();
  var car = $('#car').val();
  var pay_method = $('#pay_method').val();
  var estado_reserva = $('#estado_reserva').val();
  var ap = $('#ap').val();
  var hotel_llegada = $('#hotel_llegada').val();
  var fecha_llegada = $('#fecha_llegada').val();
  var hora_llegada = $('#hora_llegada').val();
  var aerolinea_llegada = $('#aerolinea_llegada').val();
  var vuelo_llegada = $('#vuelo_llegada').val();
  var hotel_salida = $('#hotel_salida').val();
  var departure_destino = $('#departure_destino').val();
  var fecha_salida = $('#fecha_salida').val();
  var pickup_time = $('#pickup_time').val();
  var hora_salida = $('#hora_salida').val();
  var aerolinea_salida = $('#aerolinea_salida').val();
  var vuelo_salida = $('#vuelo_salida').val();
  var bbs = $('#bbs').val();
  var crs = $('#crs').val();
  var bos = $('#bos').val();
  var balance = $('#balance').val();
  var balance_real = $('#balance_real').val();
  var shopping = $('#shopping').val();
  var obs = $('#obs').val();
  var obs_int = $('#obs_int').val();
  var add_service = true;
  var serviceType = $('input[name="service_type"]:checked').val();
  var noTotal = $('#noTotal').val();
  var agenciaProveedor = $('#agencia-proveedor').val();
  var costoProveedor = $('#costo-proveedor').val();
  var folio = $('#folio').val();

  //si agencia es = 'Sin Agencia' mostramos un alert con sweetalert para decirle que es necesario este campo
  console.log('agencia ' + agencia);
  if (agencia == 'Sin Agencia' || agencia == '') {
    Swal.fire({
      title: 'Error',
      text: 'Es necesario seleccionar una agencia',
      icon: 'error'
    });
    return;
  }

  $.ajax({
      type: "POST",
      url: "func/add-reserva.php",
      data: {
          ida: ida,
          agencia: agencia,
          name: name,
          email: email,
          phone: phone,
          pax: pax,
          car: car,
          total: balance,
          pagado: balance_real,
          pay_method: pay_method,
          estado_reserva: estado_reserva,
          ap: ap,
          hotel_llegada: hotel_llegada,
          fecha_llegada: fecha_llegada,
          hora_llegada: hora_llegada,
          aerolinea_llegada: aerolinea_llegada,
          vuelo_llegada: vuelo_llegada,
          hotel_salida: hotel_salida,
          departure_destino: departure_destino,
          fecha_salida: fecha_salida,
          pickup_time: pickup_time,
          hora_salida: hora_salida,
          aerolinea_salida: aerolinea_salida,
          vuelo_salida: vuelo_salida,
          bbs: bbs,
          crs: crs,
          bos: bos,
          shopping: shopping,
          obs: obs,
          obs_int: obs_int,
          add_service: add_service,
          serviceType: serviceType,
          noTotal: noTotal,
          agenciaProveedor: agenciaProveedor,
          costoProveedor: costoProveedor,
          folio: folio
      },
      success: function (data) {
        try {
            var data = JSON.parse(data);
            console.log(data);
    
            if (data.status === 'success') {
                // Ocultar el modal.
                $('#crear_reserva_modal').modal('hide');
    
                // Mostrar alerta de éxito con SweetAlert.
                Swal.fire({
                    title: 'Reserva creada',
                    text: 'La reserva ha sido creada correctamente',
                    icon: 'success'
                }).then(function() {
                    // recargar la pagina despues de cerrar el alert
                    location.reload();
                });
    
            } else if (data.status === 'error') {
                console.log(data);
                alert(data.message);
            } else {
                console.log(data);
                alert('Respuesta desconocida');
            }
        } catch (error) {
            console.error("Error parsing JSON: ", error);
            console.log("Raw data: ", data);
        }
    }
    
  });
});


  

  $(document).on("click", ".eliminar-reserva", function() {

    var datos = $(this).data('datos');

    //alert de sweetalert2 para confirmar la eliminación

    Swal.fire({

      title: '¿Estás seguro?',

      icon: 'question',

      showCancelButton: true,

      cancelButtonText: 'Cancelar',

      confirmButtonText: 'Sí, bórralo!'

    }).then((result) => {

      if (result.isConfirmed) {

        // si el usuario confirma la eliminación

        $.ajax({

          type: "POST",

          url: "func/api-delete-reserva.php",

          data: {idr:datos, metodo:'eliminar'},

          success: function(data) {

            var data = JSON.parse(data);

            console.log(data);

            if (data.status === 'ok') {

              Swal.fire(

                'Eliminado!',

                data.message,

                'success'

              ).then((result) => {

                if (result.isConfirmed) {

                  location.reload();

                }

              });

              

            } else if (data.status === 'error') {

              Swal.fire(

                'Error!',

                data.message,

                'error'

              );

            } else {

              Swal.fire(

                'Error!',

                'Respuesta desconocida',

                'error'

              );

            }

          }

        });

      }

    });

  });

  $('#shopping, #edit-shopping').change(function() {

    if ($(this).is(':checked')) {
      $(this).val('1');
      } else {
        $(this).val('0');
       }
  });

  function add_chofer(){

    var chofer = document.getElementById("id_chofer").value;
    var idr = document.getElementById("idr-chofer").value;


    $.ajax({
        type: "POST",
        url: "func/add_chofer.php",
        data: {chofer:chofer, idr:idr},
        success: function(response) {
            var data = JSON.parse(response);
            console.log(data);

            if(data.response == 'success'){
                //escondemos el modal con el id add_chofer
                $('#add_chofer').modal('hide');
                salidas.ajax.reload();
                llegadas.ajax.reload();
                translados.ajax.reload();

            }else{
                //alert de sweetalert2 para confirmar que no se agrego el chofer on un timer para luego recargar la pagina
                Swal.fire({
                    title: 'No se pudo agregar el chofer',
                    icon: 'error',
                    timer: 1500,
                    showConfirmButton: false
                }).then(function() {
                    location.reload();
                });

            }
        }
    });

    

}


$(document).on("click", ".add-choferes", function() {
    var idr = $(this).data('idr');
    
    $("#idr-chofer").val(idr);
    //ejecutamos la funcion add_chofer
   
  });

    $(document).on("click", "#asignar_chofer", function() {
        //cerramos el modal de asignar chofer
        $('#add_chofer').modal('hide');
        add_chofer();
    });

    $(document).on("click", ".add-proveedor", function() {
      var idr = $(this).data('idr');
      $("#idr-proveedor").val(idr);
    });

       $(document).on("click", "#asignar_proveedor", function() {
        // Obtener los valores de los campos de entrada
        var idrProveedor = $('#idr-proveedor').val();
        var selectProveedor = $('#selectProveedor').val();
        console.log('IDR Proveedor: ' + idrProveedor);
        console.log('Proveedor Seleccionado: ' + selectProveedor);

        //escondemos el modal con el id add_proveedor
        $('#update_proveedor_modal').modal('hide');
    
        // Enviar los datos por AJAX
        $.ajax({
            url: 'func/updateProveedor.php',
            type: 'POST',
            data: {
                idr_proveedor: idrProveedor,
                select_proveedor: selectProveedor
            },
            success: function(response) {
                // mostrar alert con sweetalert2
                Swal.fire({
                    title: 'Proveedor asignado',
                    text: 'El proveedor ha sido asignado correctamente',
                    icon: 'success'
                }).then(function() {
                    // Recargar la página
                    salidas.ajax.reload();
                    llegadas.ajax.reload();
                    translados.ajax.reload();

                });
                console.log(response);
            },
            error: function(xhr, status, error) {
                // Manejar errores
                Swal.fire({
                    title: 'Error',
                    text: 'Hubo un error al asignar el proveedor',
                    icon: 'error'
                });
                console.error(xhr.responseText);
            }
        });
    });

    

});