document.addEventListener('DOMContentLoaded', function() {
  fetchNextService(); // Llama a la función al cargar la página.
});

function fetchNextService() {
  fetch('func/widget-servicio-actual.php') // Asegúrate de usar la URL correcta.
    .then(response => {
      if (!response.ok) {
        throw new Error('Network response was not ok');
      }
      return response.json();
    })
    .then(data => {
      if (data && data.service) { // Verifica si el servicio está presente en los datos.
        const nextService = data;
        document.getElementById('serviceTime').textContent = formatDate(nextService.nextServiceTime);
        //ponemos el nombre del pasajero en el valor del boton con elemento con id nameSing
        $('#nameSing').val(nextService.name);
        $('#idr').val(nextService.idr);
        $('#verDetallesBtn').attr('data-datos', nextService.idr);
         $('#generar_pdf_actual').attr('href', 'my-reservation.php?idr='+ nextService.idr + '&ida=DESER&back=0&url=servicios&admin=1&action=pdf');
        //si shopping es igual a 1 sañadimos el icono <i id="shoppingIcon"class="fa-solid fa-cart-shopping"></i> al elemento con id icons
        if (nextService.shopping == 1) {
          $('#shoppingIcon').show();
          //le añadimos un tooltip al icono de carrito de compras de esta manera data-bs-toggle="tooltip" data-bs-offset="0,4" data-bs-placement="top" data-bs-custom-class="tooltip-primary" title="Primary tooltip"
        } else {
          $('#shoppingIcon').hide();
        }
        //verificamos si el servicio requiere babyseat, carseat o boosterseat
        if (nextService.babyseat >= 1) {
          $('#babyseatIcon').show();
          //añadiños title="Requiere + nextService.babyseat+ " asiento(s) para bebé" al icono de babyseat
          document.getElementById('babyseatIcon').setAttribute('title', 'Requiere '+ nextService.babyseat+ ' asiento(s) (Baby seat)');
            // Inicializa el tooltip
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
            var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
              return new bootstrap.Tooltip(tooltipTriggerEl)
            })
        } else {
          $('#babyseatIcon').hide();
        }
        if (nextService.carseat >= 1) {
          $('#carseatIcon').show();
          //añadimos title="Requiere + nextService.carseat+ " asiento(s) para niño" al icono de carseat
          document.getElementById('carseatIcon').setAttribute('title', 'Requiere '+ nextService.carseat+ ' asiento(s) (Car seat)');
            // Inicializa el tooltip
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
            var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
              return new bootstrap.Tooltip(tooltipTriggerEl)
            })
        } else {
          $('#carseatIcon').hide();
        }
        if (nextService.boosterseat >= 1) {
          $('#boosterseatIcon').show();
          //añadimos title="Requiere + nextService.boosterseat+ " asiento(s) para niño" al icono de boosterseat
          document.getElementById('boosterseatIcon').setAttribute('title', 'Requiere '+ nextService.boosterseat+ ' asiento(s) (Booster seat)');
            // Inicializa el tooltip
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
            var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
              return new bootstrap.Tooltip(tooltipTriggerEl)
            })
        } else {
          $('#boosterseatIcon').hide();
        }
      
        //si status es igual a "Confirmed" se cambia el color del texto a verde
        if (nextService.status == "Confirmed") {
          document.getElementById('serviceStatus').style.color = 'green';
          document.getElementById('serviceStatus').innerHTML = nextService.status + ' <i class="fa-regular fa-pen-to-square" id="edit_status" data-idr="'+ nextService.idr + '"></i>';
        }
        if (nextService.status == "Completed") {
          document.getElementById('serviceStatus').style.color = 'blue';
          document.getElementById('serviceStatus').innerHTML = nextService.status + ' <i class="fa-regular fa-pen-to-square" id="edit_status" data-idr="'+ nextService.idr + '"></i>';
        } else if (nextService.status == "Cancelled"){
          document.getElementById('serviceStatus').style.color = 'red';
          document.getElementById('serviceStatus').innerHTML = nextService.status + ' <i class="fa-regular fa-pen-to-square" id="edit_status" data-idr="'+ nextService.idr + '"></i>';
        }
        if (nextService.status != "Completed") {
          document.getElementById('serviceStatus').textContent = nextService.status;
          document.getElementById('serviceStatus').innerHTML = nextService.status + ' <i class="fa-regular fa-pen-to-square" id="edit_status" data-idr="'+ nextService.idr + '"></i>';
        }

        if(nextService.status == "No Show"){
          document.getElementById('serviceStatus').style.color = 'orange';
          document.getElementById('serviceStatus').innerHTML = nextService.status + ' <i class="fa-regular fa-pen-to-square" id="edit_status" data-idr="'+ nextService.idr + '"></i>';
        }
        if(nextService.status == "Pending"){
          document.getElementById('serviceStatus').style.color = 'gray';
          document.getElementById('serviceStatus').innerHTML = nextService.status + ' <i class="fa-regular fa-pen-to-square" id="edit_status" data-idr="'+ nextService.idr + '"></i>';
        }
        //cargamos la imagen del vehiculo dependiendo nextService.car
    
        if (nextService.img != null && nextService.img != 'Sin Vehiculo') {
          document.getElementById('carImg').src = data.img; // Asignar la ruta de la imagen
        } else {
          document.getElementById('carImg').src = 'https://transbook.mx/btec/assets/img/cars/anyCar.jpg'; // Ruta de la imagen predeterminada si no se encuentra una imagen específica
        }
        

        document.getElementById('car').textContent = nextService.car;
        
        if (nextService.pay_method == 'Paid') {
          $('#servicePay').html('<i class="fas fa-money-check-alt"></i> ' + nextService.pay_method + ' $' + nextService.total);
          //pone,os la clase success al elemento con id servicePay
          document.getElementById('servicePay').classList.add('text-success');
          document.getElementById('servicePay').classList.remove('text-danger');

          //agegamo el texto marcar como pendiente al boton con el id pagado
          $('#pagado').html('<i class="fa-solid fa-xmark me-2"></i> Marcar como pago pendiente');
          //cambiemos el valor del boton con el id pagado a Pending
          $('#pagado').val('Pending');
          //cambiamos la clase del boton con el id pagado a btn-warning
          document.getElementById('pagado').classList.remove('btn-success');
          document.getElementById('pagado').classList.add('btn-warning');
        }else{
          $('#servicePay').html('<i class="fas fa-money-check-alt"></i> ' + nextService.pay_method + ' $' + nextService.total);
          //pone,os la clase danger al elemento con id servicePay
          document.getElementById('servicePay').classList.add('text-danger');
          document.getElementById('servicePay').classList.remove('text-success');
          //agegamo el texto marcar como pagado al boton con el id pagado
          $('#pagado').html('<i class="fa-solid fa-check me-2"></i> Marcar como pagado');
          $('#pagado').val('Paid');
          //cambiamos la clase del boton con el id pagado a btn-success
          document.getElementById('pagado').classList.remove('btn-warning');
          document.getElementById('pagado').classList.add('btn-success');
          //buscamos si el servicio tiene observaciones con nextService.obs_int
          if (nextService.cobro == 1) {
            $('#serviceObsInt').html('<p><b>Instrucción de cobro:</b> '+ nextService.obs_int +'</p><button type="button" class="btn btn-label-secondary btn-sm" data-toggle="modal" data-target="#modalObservaciones" id="modalObs" data-idr="'+ nextService.idr + '"><i class="fa-regular fa-pen-to-square"></i> Editar instrucciónes</button>');
          } else {
            document.getElementById('serviceObsInt').classList.remove('alert');
            document.getElementById('serviceObsInt').classList.remove('alert-warning');
            //si no trae intruccion agregamos un boton pequeño con la clase btn-warning para agregar intruccion de pago
            $('#serviceObsInt').html('<p>Sin intrucción de pago.</p><button type="button" class="btn btn-warning btn-sm" data-toggle="modal" data-target="#modalObservaciones" id="modalObs" data-idr="'+ nextService.idr + '"><i class="fas fa-exclamation-triangle"></i> Agregar instrucción de cobro</button>');
            //quitamos clase class="alert alert-warning" role="alert" al elemento con id serviceObsInt
          }
        }


        // Detalles del servicio basados en el tipo
        let details = `Detalle del servicio: Pasajero ${nextService.name}, `;
        details += `Pax: ${nextService.pax}, `;
        details += `Tel: ${nextService.phone}, `;
        var airline =  '';
        switch (nextService.service) {
          case 'ona':
          case 'tra':
          case 'ope':
            details += `<br>Destino: ${nextService.arrival_hotel}`;
            airline =  nextService.arrival_airline;
            flight = nextService.arrival_flight;
            //aplicamos la clase text-primary al elemento con id serviceText
            document.getElementById('serviceText').classList.add('text-primary');
            break;
            case 'ond':
            details += `<br>Origen ${nextService.departure_hotel}`;
            airline =  nextService.departure_airline;
            flight = nextService.departure_flight;
            //aplicamos la clase text-warning al elemento con id serviceText
            document.getElementById('serviceText').classList.add('text-warning');
            break;
          case 'roa':
            const isAfterArrival = new Date() > new Date(nextService.nextServiceTime);
            if (isAfterArrival) {
              details += `<br>Origen ${nextService.departure_hotel}`;
              airline =  nextService.departure_airline;
              flight = nextService.departure_flight;
              //aplicamos la clase text-warning al elemento con id serviceText
              document.getElementById('serviceText').classList.add('text-warning');
            } else {
              details += `<br>Destino: ${nextService.arrival_hotel}`;
              airline =  nextService.arrival_airline;
              flight = nextService.arrival_flight;
              //aplicamos la clase text-primary al elemento con id serviceText
              
            }
            break;
        }
        //si chofer no es null o viene vacio agregamos el chofer asignado a details si noi agregamos un boton para asignar chofer
        if (nextService.chofer != null && nextService.chofer != '') {
          details += `, <br>Chofer: ${nextService.chofer}`;
          details += `<br><button type="button" class="btn btn-secondary btn-sm mt-3 add-choferes" data-bs-toggle="modal" data-bs-target="#add_chofer" data-idr="${nextService.idr}"><i class="fas fa-user-tie"></i> Editar chofer</button>`;
        } else {
          details += `<button type="button" class="btn btn-warning btn-sm mt-3 add-choferes" data-bs-toggle="modal" data-bs-target="#add_chofer" data-idr="${nextService.idr}"><i class="fas fa-user-tie"></i> Asignar chofer</button>`;
        }
        //si el servicio tieneasignada una agencia la agregamos a el elemento con id agency
        if (nextService.agencia != null && nextService.agencia != '') {
          $('#agency').html('<p>Agencia: <br><span class="text-primary"><i class="fas fa-building"></i> <b>' + nextService.agencia + '</b></span></p>');
          
          //creamos un boton para que el usiario pueda editar la agencia asignada
          $('#agency').append('<button type="button" class="btn btn-secondary btn-sm mt-0 add-proveedor" data-bs-toggle="modal" data-bs-target="#add_proveedor" id="edit_agency" data-idr="'+ nextService.idr + '"><i class="fa-regular fa-pen-to-square"></i> Editar Agencia</button>');
        }else{
          $('#agency').html('<p>Agencia: <br><i class="fas fa-building"></i> Sin agencia asignada</p>');
          //creamos un boton para que el usiario pueda agregar la agencia asignada
          $('#agency').append('<button type="button" class="btn btn-warning btn-sm add-proveedor" data-bs-toggle="modal" data-bs-target="#add_proveedor" id="edit_agency" data-idr="'+ nextService.idr + '"><i class="fas fa-building"></i> Asignar Agencia</button>');
        }
        
        if (nextService.empresa != null && nextService.empresa != '') {
          $('#proveedorText').html('<p>Proveedor: <br><span class="text-primary"><i class="fas fa-building"></i> <b>' + nextService.empresa + '</b></span></p>');
          $('#proveedorText').append('<button type="button" class="btn btn-secondary btn-sm mt-0 actualizar-proveedor" data-bs-toggle="modal" data-bs-target="#actualizar_proveedor" id="edit_empresa" data-idr="'+ nextService.idr + '"><i class="fa-regular fa-pen-to-square"></i> Editar Proveedor</button>');
        }else{
         
        }

        document.getElementById('serviceText').textContent =  nextService.serviceText;
        document.getElementById('aerolinea').textContent =  airline + ' ' + flight;
        document.getElementById('serviceDetails').innerHTML = details;
        //ponemor el idr en el data-idr del boton con el id verDetallesBtn
        
      } else {
        console.error('No se encontraron servicios próximos');
        document.getElementById('serviceTime').textContent = 'Hora de salida: No disponible';
        document.getElementById('serviceStatus').textContent = 'Estado: No disponible';
        document.getElementById('serviceDetails').textContent = 'Detalle del servicio: No disponible';
        document.getElementById('carImg').src = 'https://transbook.mx/btec/assets/img/cars/anyCar.jpg';
      }
    })
    .catch(error => {
      console.error('Error al cargar los datos del servicio:', error);
      document.getElementById('serviceTime').textContent = 'Se han completado todos los servicios.';
      document.getElementById('serviceStatus').textContent = 'Se completarón todos los servicios.';
      document.getElementById('serviceDetails').textContent = 'Por favor, intente de nuevo más tarde.';
      document.getElementById('carImg').src = 'https://transbook.mx/btec/assets/img/cars/anyCar.jpg';
    });
}

// Función para formatear la fecha y la hora de manera legible
function formatDate(dateString) {
  const date = new Date(dateString);
  if (isNaN(date.getTime())) {
    return "No se asignó hora de servicio";
  } else {
    const date = new Date(dateString);
    const options = { hour: '2-digit', minute: '2-digit', hour12: true };
    return date.toLocaleTimeString('es-MX', options);
  }
}

  
  