<?php
header('Content-Type: application/json; charset=utf-8');
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
date_default_timezone_set('America/Mazatlan');

$today = date('Y-m-d'); // Fecha de hoy
$now = date('Y-m-d H:i:s'); // Fecha y hora actuales

include 'conn.php';
include 'ida.php';

$sql = "SELECT * FROM (
    SELECT 
        reservas.*, 
        cars.img, -- Agregamos la columna img de la tabla cars
        proveedores.empresa, -- Agregamos el nombre del proveedor desde la tabla proveedores
        
        CASE 
            WHEN service = 'ona' THEN CONCAT(arrival_date, ' ', COALESCE(arrival_time, '00:00:00'))
            WHEN service = 'ond' THEN CONCAT(departure_date, ' ', COALESCE(departure_pickuptime, '00:00:00'))
            WHEN service = 'roa' AND CURDATE() <= arrival_date THEN CONCAT(arrival_date, ' ', COALESCE(arrival_time, '00:00:00'))
            WHEN service = 'roa' AND CURDATE() > arrival_date THEN CONCAT(departure_date, ' ', COALESCE(departure_pickuptime, '00:00:00'))
            WHEN service = 'tra' THEN CONCAT(arrival_date, ' ', COALESCE(arrival_time, '00:00:00'))
            WHEN service = 'ope' THEN CONCAT(arrival_date, ' ', COALESCE(arrival_time, '00:00:00'))
            ELSE NULL
        END AS nextServiceTime,
        CASE 
            WHEN service = 'ona' THEN arrival_airline
            WHEN service = 'ond' THEN departure_airline
            WHEN service = 'roa' AND CURDATE() <= arrival_date THEN arrival_airline
            WHEN service = 'roa' AND CURDATE() > arrival_date THEN departure_airline
            WHEN service = 'tra' THEN arrival_airline
            WHEN service = 'ope' THEN arrival_airline
            ELSE NULL
        END AS airline,
        CASE 
            WHEN service = 'ona' THEN arrival_flight
            WHEN service = 'ond' THEN departure_flight
            WHEN service = 'roa' AND CURDATE() <= arrival_date THEN arrival_flight
            WHEN service = 'roa' AND CURDATE() > arrival_date THEN departure_flight
            WHEN service = 'tra' THEN arrival_flight
            WHEN service = 'ope' THEN arrival_flight
            ELSE NULL
        END AS flight
    FROM 
        reservas 
    LEFT JOIN 
        cars ON reservas.car = cars.car -- Hacemos el JOIN utilizando la columna car
    LEFT JOIN 
        proveedores ON reservas.proveedor_id = proveedores.id -- Hacemos el JOIN utilizando la columna proveedor_id
    WHERE (reservas.arrival_date = CURDATE() OR reservas.departure_date = CURDATE()) 
    AND reservas.status != 'Completed' 
    AND reservas.status != 4 
    AND reservas.ida = '$ida'
) AS derivedTable
WHERE 
    nextServiceTime >= '$now'
ORDER BY 
    nextServiceTime ASC
LIMIT 1;
";

$stmt = $conn->prepare($sql);
if ($stmt) {
    // La consulta anterior no tiene parámetros directos, así que no usamos bind_param aquí
    $stmt->execute();
    $result = $stmt->get_result();
    $services = $result->fetch_assoc(); // Obtenemos la primera fila
    
    // Ajustar el texto del servicio
    if ($services['service'] == 'ona') {
        $services['serviceText'] = 'Llegada';
    } elseif ($services['service'] == 'ond') {
        $services['serviceText'] = 'Salida';
    } elseif ($services['service'] == 'roa') {
        if ($today <= $services['arrival_date']) {
            $services['serviceText'] = 'Llegada';
        } else {
            $services['serviceText'] = 'Salida';
        }
    }
    
    // Enviar la respuesta como JSON
    echo json_encode($services);

    $stmt->close();
} else {
    echo json_encode(array("error" => $conn->error));
}

$conn->close();
?>


